/*
 * @(#)HTMLToolBarFactory.java  1.0  24. Februar 2006
 *
 * Copyright (c) 2006 Werner Randelshofer
 * Staldenmattweg 2, CH-6405 Immensee, Switzerland
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * Werner Randelshofer. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Werner Randelshofer.
 */

package ch.randelshofer.html;

import javax.swing.*;
import javax.swing.text.html.*;
import org.jhotdraw.util.ResourceBundleUtil;
/**
 * HTMLToolBarFactory.
 * 
 * 
 * @author Werner Randelshofer
 * @version 1.0 24. Februar 2006 Created.
 */
public class HTMLToolBarFactory {
    private static ResourceBundleUtil labels = ResourceBundleUtil.getBundle("ch/randelshofer/html/Labels");
    
    /** Prevent instance creation. */
    private HTMLToolBarFactory() {
    }
    
    public static void addHTMLButtonsTo(JToolBar tb) {
        addActionsTo(new String[] {
            "InsertHR",
            "InsertOrderedList", "InsertOrderedListItem",
            "InsertUnorderedList", "InsertUnorderedListItem",
            "InsertTable", "InsertTableDataCell", "InsertTableRow",
            "InsertPre",
            null,
            "font-bold", "font-italic", "font-underline",
            null,
            "left-justify", "center-justify", "right-justify",
        }, tb);
    }
    
    private static void addActionsTo(String[] names, JToolBar tb) {
        JTextPane editor = new JTextPane();
        editor.setEditorKit(new HTMLEditorKit());
        Action[] editorActions = editor.getActions();
        for (String name : names) {
            if (name == null) {
                tb.addSeparator();
            } else {
                for (Action action : editorActions) {
                    if (action.getValue(Action.NAME).equals(name)) {
                        JButton button = tb.add(action);
                        labels.configureButton(button, "html"+name);
                        button.setFocusable(false);
                        button.setText(null);
                        break;
                    }
                }
            }
        }
    }
    
}

